//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file KBRTestApp.h
 * @author Bernhard Heep
 */

#ifndef __KBRTESTAPP_H_
#define __KBRTESTAPP_H_

#include <omnetpp.h>

#include <OverlayKey.h>

#include "BaseApp.h"


/**
 * Test application for KBR interface
 *
 * Test application for KBR interface that sends periodically
 * test messages to random keys or existing nodeIDs. The receiver does
 * not send back any answer, but sender::evaluateDate() is called.
 */
class KBRTestApp : public BaseApp
{
protected:

    void initializeApp(int stage);
    void finishApp();
    void handleTimerEvent(cMessage* msg);

    void deliver(OverlayKey& key, cMessage* msg);

    /**
     * Analyses and records measuring data handed over from
     * nodes that previously
     * had been the destination for a test message from this module,
     * called by receiver::handleMessage() at sendermodule
     *
     * @param timeDelay packet-delay
     * @param hopCount packet hop-count
     * @param bytes packet size in bytes
     */
    void evaluateData(simtime_t timeDelay, int hopCount, long int bytes);

    double mean; //!< mean time interval between sending test messages
    double deviation; //!< deviation of time interval
    bool activeNetwInitPhase; //!< is app active in network init phase?
    bool lookupNodeIds;  //!< lookup only existing nodeIDs

    int numDelivered; //!< number of delivered packets
    int bytesDelivered; //!< number of delivered bytes

    cOutVector delayVector; //!< statistical output vector for packet-delays
    cOutVector hopCountVector; //!< statistical output vector for hop-counts
};

#endif
