//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file BootstrapOracle.cc
 * @author Markus Mauch, Robert Palmer
 */

#include <omnetpp.h>

#include <OverlayKey.h>

#include "BootstrapOracle.h"


Define_Module(BootstrapOracle);

void BootstrapOracle::initialize()
{
    maxNumberOfKeys = par("maxNumberOfKeys");
    keyProbability = par("keyProbability");
    WATCH_SET(peerSet);
    WATCH_VECTOR(keyList);
    createKeyList(maxNumberOfKeys);
}

void BootstrapOracle::handleMessage(cMessage* msg)
{
    error("this module doesn't handle messages, it runs only in initialize()");
}

const NodeHandle& BootstrapOracle::getBootstrapNode()
{
    if(peerSet.size() == 0)
        return NodeHandle::UNSPECIFIED_NODE;
    else {
        // return random NodeHandle in O(log n)

        NodeHandle tmpHandle(OverlayKey::random(),
			     IPAddress::UNSPECIFIED_ADDRESS, 0, 0);
        std::set
            <NodeHandle>::iterator it = peerSet.insert(tmpHandle).first;
        peerSet.erase(it++);

        if (it == peerSet.end())
            it = peerSet.begin();

        return *it;
    }
}

void BootstrapOracle::registerPeer(const NodeHandle& peer)
{
    peerSet.insert(peer);
}

void BootstrapOracle::removePeer(const NodeHandle& peer)
{
    peerSet.erase(peer);
}

void BootstrapOracle::createKeyList(uint size)
{
    for(uint i = 0; i < size; i++)
        keyList.push_back(OverlayKey::random());
}

BootstrapOracle::KeyList* BootstrapOracle::getKeyList(uint maximumKeys)
{
    if (maximumKeys > keyList.size()) {
	maximumKeys = keyList.size();
    }
    // copy keylist to temporary keylist
    KeyList tmpKeyList;
    tmpKeyList.clear();
    for ( uint i=0; i < keyList.size(); i++ )
        tmpKeyList.push_back(keyList[i]);

    KeyList* returnList = new KeyList;

    for ( uint i=0; i < ((float)maximumKeys * keyProbability); i++) {
        uint index = intuniform(0, tmpKeyList.size()-1);
        returnList->push_back(tmpKeyList[index]);
        tmpKeyList.erase(tmpKeyList.begin()+index);
    }

    return returnList;
}

const OverlayKey& BootstrapOracle::getRandomKeyListItem() const
{
    return keyList[intuniform(0,keyList.size()-1)];
}
