//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file BootstrapOracle.h
 * @author Markus Mauch, Robert Palmer
 */

#ifndef __BOOTSTRAPORACLE_H__
#define __BOOTSTRAPORACLE_H__

#include <set>
#include <vector>

#include <omnetpp.h>

#include <NodeHandle.h>
#include <OverlayKey.h>


/**
 * Global modul that supports bootstrap process and key distribution
 *
 * @author Markus Mauch, Robert Palmer
 */
class BootstrapOracle : public cSimpleModule
{
public:

    typedef std::vector<OverlayKey> KeyList;

    /**
     * Returns a random node handle
     *
     * Returns a random node handle from the peer set if at least one peer has
     * been registered, and an empty node handle otherwise.
     *
     * @return bootstrap node
     */
    virtual const NodeHandle& getBootstrapNode();

    /**
     * Adds new peers to the peer set.
     *
     * @param peer node to register
     */
    virtual void registerPeer(const NodeHandle& peer);

    /**
     * Removes a peer from the peer set.
     *
     * @param peer node to remove
     */
    virtual void removePeer(const NodeHandle& peer);

    /**
     * Returns a keylist
     *
     * @param maximumKeys maximum number of keys in new keylist
     * @return pointer to new keylist
     */
    virtual KeyList* getKeyList(uint maximumKeys);

    /**
     * Returns random key from list
     *
     * @return the key
     */
    virtual const OverlayKey& getRandomKeyListItem() const;

protected:

    /**
     * Init member function of module
     */
    virtual void initialize();

    /**
     * HandleMessage member function of module
     */
    virtual void handleMessage(cMessage* msg);

    /**
     * Member function to create keylist
     *
     * @param size size of new keylist
     */
    virtual void createKeyList(uint size);

    KeyList keyList; //!< the keylist

    std::set
        <NodeHandle> peerSet; //!< Set of nodes participating the overlay

    // OMNeT++ parameters
    uint maxNumberOfKeys; //!< parameter used by createKeyList()
    double keyProbability; //!< probability of keys to be owned by nodes
};

#endif
