
#ifndef __COMPARATOR_H
#define __COMPARATOR_H

#include<OverlayKey.h>

/**
 * Default Comparator
 */
template<class T>
class Comparator
{
public:
    virtual ~Comparator()
    {}

    virtual int compare( const T& lhs, const T& rhs ) const
    {
        return lhs.compareTo(rhs);
    }
};

/**
 * OverlayKey comparator
 */
class KeyComparator : public Comparator<OverlayKey>
    {}
;

/**
 * OverlayKey standard metric
 */
class KeyStdMetric
{
public:
    inline OverlayKey distance( const OverlayKey& x,
				const OverlayKey& y ) const
    {
        return x > y ? (x-y) : (y-x);
    }
};

/**
 * OverlayKey XOR Metric
 */
class KeyXorMetric
{
public:
    inline OverlayKey distance( const OverlayKey& x, 
				const OverlayKey& y ) const
    {
        return x^y;
    }
};

/**
 * OverlayKey distance comparator
 */
template<class Metric = KeyStdMetric>
class KeyDistanceComparator : public Comparator<OverlayKey>
{
private:
    OverlayKey key;
    Metric m;
public:
    KeyDistanceComparator( const OverlayKey& relativeKey )
    {
        this->key = relativeKey;
    }

    int compare( const OverlayKey& lhs, const OverlayKey& rhs ) const
    {
        return (lhs^key).compareTo(rhs^key);
    }
};

#endif

