//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file GenericPacketParser.cc
 * @author Bernhard Heep
 */

#include <omnetpp.h>

#include "GenericPacketParser.h"

Define_Module(GenericPacketParser);

char* GenericPacketParser::encapsulatePayload(cMessage *msg, unsigned int* length)
{
    commBuffer.reset();
    commBuffer.packObject(msg);

    *length = commBuffer.getMessageSize();    
    char* byte_buf = new char[*length];
    memcpy(byte_buf, commBuffer.getBuffer(), *length);

    return byte_buf;
}

cMessage* GenericPacketParser::decapsulatePayload(char* buf, unsigned int length)
{
    commBuffer.reset();
    commBuffer.pack(buf, length);
    cMessage* msg;

    try {
	msg = check_and_cast<cMessage*>(commBuffer.unpackObject());
//    } catch (cRuntimeError err) {
//    FIXME:
//    the above does, for some reason, not work. So we catch everyting, 
//    which may prevent the simulation from terminating corectly while
//    parsing a message.
    } catch (...) {
	ev << "GenericPacketParser: parsing of payload failed.\n";
	return NULL;
    }
    
    return msg;
}

