//
// Copyright (C) 2007 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file GlobalStatistics.cc
 * @author IngmarBaumgart
 */

#include <omnetpp.h>

#include "GlobalStatistics.h"

Define_Module(GlobalStatistics);

void GlobalStatistics::initialize()
{
    sentKBRTestAppMessages = 0;
    deliveredKBRTestAppMessages = 0;
    sentTotalBytes = 0;
    testCount = 0;

    globalDelayVector.setName("Global Delay Time");
    currentDeliveryVector.setName("Current Delivery Ratio");

    // start periodic globalStatTimer
    cMessage* globalStatTimer = new cMessage("globalStatTimer");
    scheduleAt(simulation.simTime() + 120, globalStatTimer);

    WATCH(sentTotalBytes);
    WATCH(globalDelayVector);
    WATCH(currentDeliveryVector);
}

void GlobalStatistics::handleMessage(cMessage* msg)
{
    if (msg->isName("globalStatTimer")) {
        // schedule next timer event
        scheduleAt(simulation.simTime() + 120, msg);

	double ratio;

	if (sentKBRTestAppMessages == 0) {
	    ratio = 0;
	} else {
	    ratio = (double)deliveredKBRTestAppMessages /
		    (double)sentKBRTestAppMessages;
	}
	if (ratio > 1) ratio = 1;

	currentDeliveryVector.record(ratio);
	sentKBRTestAppMessages = 0;
	deliveredKBRTestAppMessages = 0;
	
	return;
    }

    error("GlobalStatistics::handleMessage(): Unknown message type!");
}

void GlobalStatistics::finish()
{
    recordScalar("GlobalStatistics: Total Sent Bytes", sentTotalBytes);

//    recordScalar("GlobalStatistics: Test Count", testCount);

}
