//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#include<NodeVector.h>

using namespace std;

NodeVector::NodeVector( uint16_t maxSize,
			const Comparator<OverlayKey>* comparator )
{
    this->maxSize = maxSize;
    this->comparator = comparator;
}

NodeVector::~NodeVector()
{}

bool NodeVector::isAddable( const NodeHandle& handle ) const
{
    return ( size() != maxSize ||
	     comparator->compare( handle.key, back().key ) < 0 );
}

bool NodeVector::add
    ( const NodeHandle& handle )
{
    // check if handle is addable
    if ( isAddable(handle) ) { // yes ->

        // add handle to the appropriate position
        if ( size() != 0 )  {
            for ( iterator i = begin(); i != end(); i++ )
                if ( comparator->compare( handle.key, i->key ) < 0 ) {
                    insert( i, handle );
                    break;
                }
        } else
            push_back(handle);

        // adjust size
        if (maxSize!=0 && size()>=maxSize)
            resize(maxSize);

        return true;
    } else
        return false;
}

