
#ifndef __NODE_VECTOR_H
#define __NODE_VECTOR_H

#include<Comparator.h>
#include<NodeHandle.h>
#include<vector>

/**
 * A NodeHandle STL-vector that supports sorted node inserts
 * 
 * @author Sebastian Mies
 */
class NodeVector : public std::vector<NodeHandle>
{

private://fields: comparator

    const Comparator<OverlayKey>* comparator;
    uint16_t maxSize;

public://construction

    NodeVector( uint16_t maxSize = 0,
		const Comparator<OverlayKey>* comparator = NULL );
    ~NodeVector();

public://methods: sorted add support

    bool isAddable( const NodeHandle& handle ) const;
    bool add( const NodeHandle& handle );
};

#endif
