#ifndef __PACKETPARSER_H__
#define __PACKETPARSER_H__

#include <omnetpp.h>

/**
 * Class that performes parsing of the payload of packets that are send to or received by the tun device
 */
class PacketParser : public cSimpleModule
{

public:
    /**
     * Called on initialisation
     */
    virtual void initialize()
    {}
    ;

    /**
     * Is called if the modules receives a message. That should never happen
     */
    virtual void handleMessage(cMessage *msg)
    {
        opp_error("A PacketParser is not intendet to receive Messages!");
    };

    /**
     * Convert a cMessage to a data block for sending it to the tun device.
     * Pure virtual function, has to be implemented by inherited classes.
     *
     * \param msg A pointer to the message to be converted
     * \param length A pointer to an integer that will hold the length of the data
     * \return A pointer to the converted data
     */
    virtual char* encapsulatePayload(cMessage *msg, unsigned int* length) = 0;

    /**
     * Parses a block of data received from the tun device.
     * Pure virtual function, has to be implemented by inherited classes.
     *
     * \param buf The data to be parsed
     * \param length The length of the data
     * \return A cMessage containing the parsed data
     */
    virtual cMessage *decapsulatePayload(char* buf, unsigned int length) = 0;
};

#endif


