//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
#ifndef __RPC_LISTENER_H
#define __RPC_LISTENER_H

#include<BaseOverlayMessage_m.h>

class BaseOverlay;

/**
 * A Remote-Procedure-Call listener class
 *
 * @author Sebastian Mies
 */
class RpcListener
{
    friend class BaseOverlay;

public:
    virtual ~RpcListener();

protected:
    /**
     * This method is called if an RPC response has been received.
     * 
     * @param msg The response message.
     * @param rpcId The RPC id.
     * @param rtt The Round-Trip-Time of this RPC
     */
    virtual void handleRpcResponse( BaseResponseMessage* msg, 
				    int rpcId, simtime_t rtt );

    /**
     * This method is called if an RPC timeout has been reached.
     * 
     * @param msg The original RPC message.
     * @param dest The destination node
     * @param rpcId The RPC id.
     */
    virtual void handleRpcTimeout( BaseCallMessage* msg,
				   const NodeHandle& dest, int rpcId );
};

#endif
