//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file UnderlayConfigurator.cc
 * @author Stephan Krause, Bernhard Heep
 */

#include <omnetpp.h>

#include "UnderlayConfigurator.h"


int UnderlayConfigurator::numInitStages() const
{
    return MAX_STAGE_UNDERLAY + 1;
}

void UnderlayConfigurator::initialize(int stage)
{
    if(stage == MIN_STAGE_UNDERLAY) {
        initialOverlayTerminalNum = par("initialOverlayTerminalNum");
        targetOverlayTerminalNum = par("targetOverlayTerminalNum");
        creationProbability = par("creationProbability");
        migrationProbability = par("migrationProbability");
        removalProbability = par("removalProbability");
        initialMean = par("initialMobilityDelay");
        initialDeviation = initialMean / 3;
        targetMean = par("targetMobilityDelay");
	WATCH(targetMean);
        //targetDeviation = targetMean / 3;
        channelTypes = cStringTokenizer(par("channelTypes"), " ").asVector();
	init = true;
	gettimeofday(&initFinishedTime, NULL);
	keepFirstNode = par("keepFirstNode");
	firstNodeId = -1;
	WATCH(firstNodeId);

	churnMsg = new cMessage;
	churnIntervalChanged = false;
    }

    if(stage >= MIN_STAGE_UNDERLAY && stage <= MAX_STAGE_UNDERLAY)
        initializeUnderlay(stage);
}

void UnderlayConfigurator::handleMessage(cMessage* msg)
{
    //schedule churnMsg
    if((double)(par("churnChangeInterval")) == 0) {
	targetMean = par("targetMobilityDelay");
	churnIntervalChanged = false;
    } else if(!churnMsg->isScheduled()) {
	scheduleAt(simulation.simTime() + (double)(par("churnChangeInterval")), churnMsg);
    }

    if(msg == churnMsg) {
	if(churnIntervalChanged) {
	    targetMean = par("targetMobilityDelay");
	    churnIntervalChanged = false;
	} else {
	    targetMean = par("targetMobilityDelay2");
	    churnIntervalChanged = true;
	}
	std::stringstream temp;
	temp << "Churn-rate changed to " << targetMean;
	bubble(temp.str().c_str());
    }
    else if ( init ) {
        // increase the number of nodes steadily during setup

        init = (overlayTerminalCount < (int)par("targetOverlayTerminalNum"));

        if (!init)
            gettimeofday(&initFinishedTime, NULL);
        else
            createRandomNode(false);

        scheduleAt(simulation.simTime()
		   + truncnormal(initialMean, initialDeviation), msg);
    } else {	      
	double random = uniform(0, 1);

	// modify the number of nodes according to user parameters
	if (overlayTerminalCount != 0) {
	    if(random < creationProbability) {
		createRandomNode(false);
	    } else if(creationProbability <= random &&
		      random < creationProbability + removalProbability &&
		      overlayTerminalCount > 1) {
		killRandomNode();
	    } else if ( creationProbability + removalProbability <= random &&
			random < creationProbability + removalProbability
			+ migrationProbability) {
		migrateRandomNode();
	    }
	}
	scheduleAt(simulation.simTime() + truncnormal(targetMean, targetMean / 3), msg);
    }
    setDisplayString();
}

