//==========================================================================
//  INDEX.H - part of
//                          OverSim
//            A Flexible Overlay Simulation Framework
//
//  Defines modules for documentation generation. Nothing useful for the
//  C++ compiler.
//
//==========================================================================

/**
 * @mainpage OverSim API Reference
 *
 * Pick one of the entries in the following categories, or choose from the
 * links at the top of this page:<br>
 *
 * <b>Underlay</b> - underlying network modelling classes<br>
 *   - Underlay configurator base class (UnderlayConfigurator)<br>
 *     - for SimpleUnderlay (SimpleNetConfigurator)<br>
 *     - for IPv4Underlay (IPv4UnderlayConfigurator)<br>
 *
 * <b>Overlay</b> - overlay classes and message types<br>
 * - Base class for overlay modules on Tier 0 / KBR (BaseOverlay)<br>
 *   - structured overlay Chord
 *   - unstructured overlay Gia
 * - Base class for lookups in the overlay (BaseLookup)<br>
 *
 * <b>Application</b> - application classes and message types<br>
 * - Base class for Applications on Tier 1 (BaseApp)<br>
 *   - Test application for Key-based routing (KBRTestApp)<br>
 *   - Application for testing Gia searching (GIASearchApp)<br>
 *
 * If you want to use, copy, change or distribute OverSim read the @ref GPL
 */

/**
 * @page GPL
 *
 * @verbinclude License
 */
