//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file FingerTable.cc
 * @author Markus Mauch, Ingmar Baumgart
 */

#include <omnetpp.h>
#include <IPAddressResolver.h>

#include <NodeHandle.h>
#include <OverlayKey.h>

#include "FingerTable.h"


Define_Module(FingerTable);

void FingerTable::initialize(int stage)
{
    // because of IPAddressResolver, we need to wait until interfaces
    // are registered, address auto-assignment takes place etc.
    if(stage != MIN_STAGE_OVERLAY)
        return;

    WATCH_VECTOR(fingerTable);
}

void FingerTable::handleMessage(cMessage* msg)
{
    error("this module doesn't handle messages, it runs only in initialize()");
}

void FingerTable::initializeTable(uint size, NodeHandle owner)
{
    fingerTable.assign(size, owner);
}

uint FingerTable::getSize()
{
    return fingerTable.size();
}

void FingerTable::setFinger(uint pos, NodeHandle node)
{
    if (pos < fingerTable.size()) {
        fingerTable[pos] = node;
    } else {
        error("Index out of bound (FingerTable, setFinger())");
    }
}

const NodeHandle& FingerTable::getFinger(uint pos)
{
    if (pos >= fingerTable.size())
        error("Index out of bound (FingerTable, getFinger())");

    return fingerTable[pos];
}
