//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file FingerTable.h
 * @author Markus Mauch, Ingmar Baumgart
 */

#ifndef __FINGERTABLE_H_
#define __FINGERTABLE_H_

#include <vector>

#include <omnetpp.h>

#include <NodeHandle.h>
#include <InitStages.h>

/**
 * Finger table module
 *
 * This modul contains the finger table of the Chord implementation.
 *
 * @author Markus Mauch, Ingmar Baumgart
 * @see Chord
 */
class FingerTable : public cSimpleModule
{
  public:
    virtual int numInitStages() const
    {
        return MAX_STAGE_OVERLAY + 1;
    }

    virtual void initialize(int stage);
    virtual void handleMessage(cMessage* msg);

    /**
     * Sets up the finger table
     *
     * Sets up the finger table and makes all fingers pointing
     * to the node itself. Should be called on startup to initialize
     * the finger table.
     *
     * @param size number of fingers
     * @param owner set all fingers to the key of node handle owner
     */
    virtual void initializeTable(uint size, NodeHandle owner);

    /**
     * Sets a particular finger to point to node
     *
     * @param pos number of the finger to set
     * @param node set finger to this node
     */
    virtual void setFinger(uint pos, NodeHandle node);

    /**
     * Returns the NodeHandle of a particular finger
     *
     * @param pos number of the finger to get
     * @return NodeHandle of the particular finger
     */
    virtual const NodeHandle& getFinger(uint pos);

    /**
     * Returns the size of the finger table
     *
     * @return number of fingers
     */
    virtual uint getSize();

  protected:
    std::vector<NodeHandle> fingerTable; /**< the finger table vector */
};

#endif
