//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file GiaNode.cc 
 * @author Robert Palmer 
 */
#include <OverlayKey.h>

#include "GiaNode.h"


// predefined gia node
const GiaNode GiaNode::UNSPECIFIED_NODE;

void GiaNode::setNodeHandle(const NodeHandle& nHandle)
{
    nodeHandle = nHandle;
}

GiaNode::GiaNode()
{
    specified = false;
    //GiaNode(NodeHandle(), 0, 0);
}

// GiaNode::GiaNode(NodeHandle nHandle)
// {
//     GiaNode(nHandle, 0, 0);
// }

GiaNode::GiaNode(const NodeHandle& nHandle, double cap, int degree)
{
    nodeHandle = nHandle;
    capacity = cap;
    connectionDegree = degree;
    receivedTokens = 3;
    sentTokens = 3;

    specified = true;
}

const NodeHandle& GiaNode::getNodeHandle() const
{
    return nodeHandle;
}

void GiaNode::setCapacity(double cap)
{
    capacity = cap;
}

double GiaNode::getCapacity() const
{
    return capacity;
}

void GiaNode::setConnectionDegree(uint degree)
{
    connectionDegree = degree;
}

uint GiaNode::getConnectionDegree() const
{
    return connectionDegree;
}

void GiaNode::setReceivedTokens(uint tokenNr)
{
    receivedTokens = tokenNr;
}

uint GiaNode::getReceivedTokens() const
{
    return receivedTokens;
}

void GiaNode::setSentTokens(uint tokenNr)
{
    sentTokens = tokenNr;
}

uint GiaNode::getSentTokens() const
{
    return sentTokens;
}

std::ostream& operator<<(std::ostream& os, const GiaNode& n)
{
    if(n.nodeHandle.ip.isUnspecified() == true && n.nodeHandle.key.isUnspecified() && n.nodeHandle.port == -1) {
        os << "<unspec>";
    } else {
        os << n.nodeHandle.ip << ":" << n.nodeHandle.port << " "
        << n.nodeHandle.key.toString() << " with capacity: "
        << n.capacity << " , degree: " << n.connectionDegree
        << " , sentTokens: " << n.sentTokens << " , receivedTokens: " << n.receivedTokens;
    }
    return os;
}

bool GiaNode::operator==(const GiaNode& rhs) const
{
    if(this->getNodeHandle() != rhs.getNodeHandle())
        return false;
    return true;
}

bool GiaNode::operator!=(const GiaNode& rhs) const
{
    if(this->getNodeHandle() == rhs.getNodeHandle())
        return false;
    return true;
}
