//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file GiaNode.h
 * @author Robert Palmer 
 */

#ifndef __GIANODE_H_
#define __GIANODE_H_


#include <string>

#include <NodeHandle.h>


/**
 *
 * This class represents a node in gia overlay network
 * 
 */
class GiaNode
{
  public:
    GiaNode();

    GiaNode(const NodeHandle& nHandle, double capacity = 0, int degree = 0);

    static const GiaNode UNSPECIFIED_NODE;

    // class methodes

    /**
     * Set NodeHandle
     * @param nHandle NodeHandle to set
     */
    void setNodeHandle(const NodeHandle& nHandle);

    /**
     * Get NodeHandle
     * @return NodeHandle
     */
    const NodeHandle& getNodeHandle() const;

    /**
     * Set capacity (function of bandwidth, cpu power and HDD-fitness
     * @param capacity Capacity to set
     */
    void setCapacity(double capacity);

    /**
     * Get capacity
     * @return GiaNode
     */
    double getCapacity() const;

    /**
     * Set number of neighbors
     * @param degree Number of neighbors
     */
    void setConnectionDegree(uint degree);

    /**
     * Get connection degree
     * @return number of neighbors
     */
    uint getConnectionDegree() const;

    /**
     * Set number of received tokens
     * @param tokenNr Number of tokens
     */
    void setReceivedTokens(uint tokenNr);

    /**
     * Get number of received tokens
     * @return Number of received tokens
     */
    uint getReceivedTokens() const;

    /**
     * Set number of sent tokens
     * @param tokenNr Number of tokens
     */
    void setSentTokens(uint tokenNr);

    /**
     * Get number of sent tokens
     * @return Number of sent tokens
     */
    uint getSentTokens() const;

    inline bool isUnspecified() const
    {
        return !specified;
    };

    bool operator==(const GiaNode& rhs) const;
    bool operator!=(const GiaNode& rhs) const;

    friend std::ostream& operator<<(std::ostream& os, const GiaNode& n);

  protected:
    NodeHandle nodeHandle; /** NodeHandle of this node */
    double capacity; /** capacity of this node */
    uint connectionDegree; /** connection degree (number of current neighbors) of this node */
    uint receivedTokens; /** received tokens from another neighbor */
    uint sentTokens; /** sent tokens to another neighbor */

    bool specified; /** */
};

#endif
