//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file MessageBookkeeping.cc
 * @author Robert Palmer
 */

#include <omnetpp.h>
#include "MessageBookkeeping.h"


MessageBookkeeping::MessageBookkeeping( Neighbors* neighbors, uint timeout )
{
    this->neighbors = neighbors;
    this->timeout = timeout;
}

MessageBookkeeping::~MessageBookkeeping()
{}

uint MessageBookkeeping::getSize()
{
    return messages.size();
}

void MessageBookkeeping::addMessage( GiaIDMessage* msg )
{
    assert(!(msg->getID().isUnspecified()));

    std::vector<GiaNode> remainNodes;
    // push all neighbors except the node where message was comming from
    // to remainNodes
    for ( uint i=0; i<neighbors->getSize(); i++ )
        if ( neighbors->get
                (i)->getNodeHandle().key != msg->getSrcNode().key) //msg->getSrcKey() )
            remainNodes.push_back(*(neighbors->get
                                    (i)));
    MessageItem messageItem;
    messageItem.remainNodes = remainNodes;
    messageItem.timestamp = simulation.simTime();
    messages[msg->getID()] = messageItem;
}

void MessageBookkeeping::removeMessage( GiaIDMessage* msg )
{
    std::map<OverlayKey, MessageItem>::iterator it = messages.find(msg->getID());
    // delete message if key is equal
    if ( it->first == msg->getID() )
        messages.erase(messages.find(msg->getID()));
}

bool MessageBookkeeping::contains( GiaIDMessage* msg )
{
    std::map<OverlayKey, MessageItem>::iterator it = messages.find(msg->getID());

    if(it != messages.end()) // it->first == msg->getID() )
        return true;
    return false;
}

GiaNode* MessageBookkeeping::getNextHop( GiaIDMessage* msg )
{
    if ( neighbors->getSize() > 0 ) {
        std::map<OverlayKey, MessageItem>::iterator it = messages.find(msg->getID());
        std::priority_queue<GiaNode, std::vector<GiaNode>, nodeQueueCompare> nodeQueue;

        if ( it->first == msg->getID() ) {
            MessageItem messageItem = it->second;
            std::vector<GiaNode> remNodes = messageItem.remainNodes;
            if ( remNodes.size() == 0) {
                for ( uint i=0; i<neighbors->getSize(); i++ ) {
                    remNodes.push_back(*(neighbors->get
                                         (i)));
                }
            }

            for ( uint i=0; i<remNodes.size(); i++ ) {
                if(!(remNodes[i].isUnspecified())) //(remNodes[i] != GiaNode::UNSPECIFIED_NODE )
                    nodeQueue.push(remNodes[i]);
            }

            GiaNode* nextHop = neighbors->get
                               (nodeQueue.top());

            nodeQueue.pop();
            if ( nextHop->getReceivedTokens() > 0 ) {
                remNodes.clear();
                while ( !nodeQueue.empty() ) {
                    remNodes.push_back(nodeQueue.top());
                    nodeQueue.pop();
                }
                messageItem.remainNodes = remNodes;
                messageItem.timestamp = simulation.simTime();
                messages[msg->getID()] = messageItem;
                return nextHop;
            } else
                return NULL;
        } else
            return NULL;
    } else
        return NULL;
}

void MessageBookkeeping::removeTimedoutMessages()
{
    std::map<OverlayKey, MessageItem>::iterator it = messages.begin();
    std::map<OverlayKey, MessageItem>::iterator it2 = messages.begin();
    for ( uint i=0; i<messages.size(); i++) {
        OverlayKey key = it->first;
        MessageItem messageItem = it->second;
        it2 = it++;
        if ( simulation.simTime() > (messageItem.timestamp + timeout))
            messages.erase(it2);
    }
}

bool MessageBookkeeping::nodeQueueCompare::operator()(const GiaNode& x, const GiaNode& y)
{
    if (x.getReceivedTokens() > y.getReceivedTokens()) {
        if (y.getReceivedTokens() == 0)
            return false;
        else {
            if (x.getCapacity() >= y.getCapacity())
                return false;
            else
                return true;
        }
    }
    else if (x.getReceivedTokens() < y.getReceivedTokens()) {
        if (x.getReceivedTokens() == 0)
            return true;
        else {
            if (x.getCapacity() > y.getCapacity())
                return false;
            else
                return true;
        }
    }
    else {
        if (x.getReceivedTokens() == 0)
            return true;
        else {
            if (x.getCapacity() > y.getCapacity())
                return false;
            else
                return true;
        }
    }
}
