//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file NeighborNode.h
 * @author Robert Palmer
 */

#ifndef __NEIGHBORNODE_H_
#define __NEIGHBORNODE_H_

#include <omnetpp.h>
#include <KeyList.h>
#include "GiaNode.h"

/**
 * This class represents an neighbor node
 * It contains a gia node, a key list for this neighbor and a timestamp when the last message
 * was received from this neighbor
 */
class NeighborNode
{
  public:

    NeighborNode();
    NeighborNode(const GiaNode& node, simtime_t timestamp);

    friend std::ostream& operator<<(std::ostream& os, const NeighborNode& n);

    GiaNode giaNode; /** GiaNode of this neighbor */
    simtime_t timestamp; /** timestamp of last received message from this neighbor */
    KeyList keyList; /** key list of this neighbor */
};

#endif
