//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file Neighbors.cc
 * @author Robert Palmer
 * @todo rewrite
 */

#include <InitStages.h>

#include "Neighbors.h"


Define_Module(Neighbors);

void Neighbors::initialize( int stage )
{
    // wait until IPAddressResolver finished his initialization
    if(stage != MIN_STAGE_OVERLAY)
        return;

    WATCH_VECTOR(neighbors);
    this->timeout = parentModule()->submodule("gia")->par("neighborTimeout");
    unspecNode = GiaNode::UNSPECIFIED_NODE;
}


void Neighbors::handleMessages( cMessage* msg )
{
    error("this module doesn't handle messages, it runs only in initialize()");
}

uint Neighbors::getSize()
{
    return neighbors.size();
}

bool Neighbors::contains(const OverlayKey& key) const
{
    if (getPosition(key) != -1)
        return true;
    return false;
}

bool Neighbors::contains(const GiaNode& node) const
{
    if (getPosition(node) != -1)
        return true;
    return false;
}

int Neighbors::getPosition(const GiaNode& node) const
{
    return getPosition(node.getNodeHandle().key);
}

int Neighbors::getPosition(const OverlayKey& key) const
{
    for ( uint i=0; i<neighbors.size(); i++ )
        if ( neighbors[i].giaNode.getNodeHandle().key == key )
            return i;
    return -1;
}

void Neighbors::add
    (const GiaNode& node)
{
    if(!contains(node))
        neighbors.push_back(NeighborNode(node, simulation.simTime()));
}


//bad code, why std::vector<>?
void Neighbors::remove
    (const GiaNode& node)
{
    int position = getPosition(node);
    if ( position != -1 )
        neighbors.erase(neighbors.begin() + position);
}

//bad code
void Neighbors::remove
    (int position)
{
    if (position != -1)
        neighbors.erase( neighbors.begin() + position);
}

GiaNode* Neighbors::get
    (int position)
{
    if ( neighbors.size() == 0 || position == -1 )
        return &unspecNode;
    else
        return &neighbors[position].giaNode;
}

GiaNode* Neighbors::get
    (const GiaNode& node)
{
    if(neighbors.size() == 0)
        return &unspecNode;
    else {
        int position = getPosition(node);
        if(position == -1)
            return &unspecNode;
        else
            return get
                       (position);
    }
}

GiaNode* Neighbors::get
    (const OverlayKey& key)
{
    if(neighbors.size() == 0)
        return &unspecNode;
    else {
        int position = getPosition(key);
        if(position == -1)
            return &unspecNode;
        else
            return get
                       (position);
    }
}

void Neighbors::updateTimestamp(const GiaNode& node)
{
    int position  = getPosition(node);
    if(position != -1) {
        neighbors[position].timestamp = simulation.simTime();
    }
}

//bad code
void Neighbors::removeTimedoutNodes()
{
    std::vector<NeighborNode>::iterator it = neighbors.begin();
    std::vector<NeighborNode>::iterator it2 = neighbors.begin();
    for ( uint i=0; i<neighbors.size(); i++) {
        NeighborNode neighborNode = neighbors[i];
        it2 = it++;
        if ( simulation.simTime() > (neighborNode.timestamp + timeout))
            neighbors.erase(it2);
    }
}

void Neighbors::setNeighborKeyList(uint pos, const KeyList& keyList)
{
    neighbors[pos].keyList = keyList;
}

KeyList* Neighbors::getNeighborKeyList(uint pos)
{
    return &(neighbors[pos].keyList);
}

void Neighbors::finish()
{}

