//
// Copyright (C) 2006 Institut fuer Telematik, Universitaet Karlsruhe (TH)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file TokenFactory.cc
 * @author Robert Palmer
 */

#include "TokenFactory.h"
#include "Gia.h"


Define_Module(TokenFactory);

void TokenFactory::initialize( int stage )
{
    // wait until IPAddressResolver finished his initialization
    if(stage != MIN_STAGE_OVERLAY)
        return;

    gia = check_and_cast<Gia*>(parentModule()->submodule("gia"));

    stat_sentTokens = 0;

    WATCH(stat_sentTokens);
    WATCH_VECTOR(tokenQueueVector);
}

void TokenFactory::handleMessages( cMessage* msg )
{
    error("this module doesn't handle messages, it runs only in initialize()");
}

void TokenFactory::setNeighbors( Neighbors* nghbors )
{
    neighbors = nghbors;
}

void TokenFactory::setMaxHopCount( uint maxHopCount)
{
    this->maxHopCount = maxHopCount;
}

void TokenFactory::grantToken()
{
    // create priority queue
    createPriorityQueue();

    // update sentTokenCount at node on top of priority queue
    updateSentTokens();

    // send token to top of queue
    gia->sendToken(tokenQueue.top());

    // increse statistic variable
    stat_sentTokens++;

    updateQueueVector();
}

void TokenFactory::createPriorityQueue()
{
    clearTokenQueue();
    for ( uint i=0; i<neighbors->getSize(); i++ )
        tokenQueue.push(*(neighbors->get
                          (i)));
}

void TokenFactory::clearTokenQueue()
{
    while( !tokenQueue.empty() )
        tokenQueue.pop();
}

void TokenFactory::updateQueueVector()
{
    // fill tokenQueueVector
    tokenQueueVector.clear();
    while (!tokenQueue.empty()) {
        tokenQueueVector.push_back(tokenQueue.top());
        tokenQueue.pop();
    }
}

void TokenFactory::updateSentTokens()
{
    GiaNode* node = neighbors->get
                    (tokenQueue.top());
    uint nSentTokens = node->getSentTokens();
    node->setSentTokens(nSentTokens+1);
}

bool TokenFactory::tokenCompareGiaNode::operator()(const GiaNode& x, const GiaNode& y)
{
    if (x.getSentTokens() > y.getSentTokens())
        return true;
    if (x.getSentTokens() == y.getSentTokens())
        if (x.getCapacity() < y.getCapacity())
            return true;
    return false;
}
