set terminal postscript eps enhanced "Helvetica" 18
set output "cpu.eps"
set grid noxtics ytics
#set logscale x
set logscale y
set xlabel "Number of nodes"
set ylabel "Processing time [sec]"
set yrange [0.1:1000000]
set xrange [1:6]
set xtics ("100" 2.0, "1,000" 3.0, "10,000" 4.0, "100,000" 5.0)
set data style lines
set style fill solid
set boxwidth 0.2 relative
set encoding iso_8859_1
set label "P2PSim crashed" at 5.25,1.1 rotate by 90
plot "cpu.dat" using ($1-0.2):2 with boxes fs solid 0.1 lt 1 title "OverSim (Simple underlay)",\
"cpu.dat" using ($1):3 with boxes fs solid 0.4 lt 1 title "OverSim (IPv4 underlay)",\
"cpu.dat" using ($1+0.2):4 with boxes fs solid 1.0 lt 1 title "P2PSim"
