//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __IPV4UNDERLAYCONFIGURATOR_H__
#define __IPV4UNDERLAYCONFIGURATOR_H__

#include <vector>

#include <omnetpp.h>
#include <BasicModule.h>

#include <UnderlayConfigurator.h>
#include <InitStages.h>

#include "AccessNet.h"


/**
 * Configurator module for the IPv4Underlay
 *
 * @author Markus Mauch
 * @todo possibility to disable tier1-3 in overlay(access)routers
 */
class IPv4UnderlayConfigurator : public UnderlayConfigurator
{
public:
    /**
     * Creates an overlay node and adds it to a randomly chosen access net
     *
     * @param initialize creation during init phase?
     */
    int createRandomNode(bool initialize);

    /**
     * Removes randomly chosen overlay nodes from a randomly chosen access net
     */
    void killRandomNode();

    /**
     * Migrates randomly chosen overlay nodes from on access net to another
     */
    void migrateRandomNode();

private:
    // parameters
    int accessRouterNum;
    int overlayAccessRouterNum;
    int overlayTerminalNum;

protected:

    void initializeUnderlay(int stage);
    void finish();

    /**
     * Updates the statistics display string
     */
    void setDisplayString();
    std::vector<cModule*> accessNode;

    // statistics
    int numCreated;
    int numKilled;
};


// Extended uniform() and intuniform() functions
double uniform2(double start, double end, double index, double new_calc)
{
    static std::vector<double> value;
    if ( (uint)index >= value.size() )
        value.resize((int)index + 1);
    if ( new_calc == 1 )
        value[(int)index] = uniform(start, end);
    return value[(int)index];
};

double intuniform2(double start, double end, double index, double new_calc)
{
    static std::vector<double> value;
    if ( (uint)index >= value.size() )
        value.resize((int)index + 1);
    if ( new_calc == 1 )
        value[(int)index] = (double)intuniform((int)start, (int)end);
    return value[(int)index];
};

Define_Function(uniform2, 4);
Define_Function(intuniform2, 4);

#endif
