//
// Copyright (C) 2004 Andras Varga
// Copyright (C) 2000 Institut fuer Telematik, Universitaet Karlsruhe
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file GlobalRoutingHashMap.cc
 * @author Stephan Krause
 */

class SimpleUDPPacket;
#include "SimpleUDP.h"
#include "SimpleNodeEntry.h"

#include "GlobalRoutingHashMap.h"



Define_Module(GlobalRoutingHashMap);


//void GlobalRoutingHashMap::initialize()
//{
//    delay = par("networkdelay");
//}

GlobalRoutingHashMap::RouteEntry GlobalRoutingHashMap::getEntry( uint i ) const
{
    if (i > routeHashMap.size())
        error("GlobalRoutingHashMap::getEntry(): i > routeHashMap.size()!");

    // FIXME inefficient! is there a better way?
    RouteHashMap::const_iterator it = routeHashMap.begin();
    while( i-- )
        ++it;

    return *it;
}

void GlobalRoutingHashMap::insertNode(const IPvXAddress& addr,
				      const SimpleNodeEntry& entry)
{
    routeHashMap.insert(RouteEntry(addr, entry));
}

void GlobalRoutingHashMap::removeNode(const IPvXAddress& addr)
{
    if (!routeHashMap.erase(addr)) {
        error(("Trying to remove Host " + addr.str() +
               ", which is not in the RoutingHashMap").c_str());
    }
}

SimpleNodeEntry* GlobalRoutingHashMap::findEntryForAddress(const
							   IPvXAddress& addr)
{
    RouteHashMap::iterator r = routeHashMap.find(addr);
    if (r == routeHashMap.end())
        return NULL; // host not found
    return &(r->second);
}
