//
// Copyright (C) 2000 Institut fuer Telematik, Universitaet Karlsruhe
// Copyright (C) 2004 Andras Varga
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @author Stephan Krause
 * @date 31.05.2006
 */

#ifndef __GLOBALROUTINGHASHMAP_H
#define __GLOBALROUTINGHASHMAP_H

#include <ext/hash_map>

#include <omnetpp.h>

#include "IPvXAddress.h"
#include "ModuleAccess.h"
#include "SimpleNodeEntry.h"


//FIXME: String is slow...
namespace __gnu_cxx
{
template<>
struct hash< IPvXAddress >
{
    size_t operator()(const IPvXAddress& addr) const
    {
        return addr.isIPv6() ?  __stl_hash_string(addr.str().c_str()) : addr.get4().getInt();
    }
};
}


/**
 * @todo doxygen...
 */
class GlobalRoutingHashMap: public cSimpleModule
{
public:
    typedef std::pair<IPvXAddress, SimpleNodeEntry/*cGate* */> RouteEntry;
    void insertNode(const IPvXAddress& addr, const SimpleNodeEntry& entry);
    void removeNode(const IPvXAddress& addr);
    RouteEntry getEntry( uint i ) const;
    SimpleNodeEntry* findEntryForAddress(const IPvXAddress& addr);
    int size()
    {
        return routeHashMap.size();
    };

private:
    //simtime_t delay;
    typedef __gnu_cxx::hash_map<IPvXAddress, SimpleNodeEntry/*cGate* */> RouteHashMap;
    RouteHashMap routeHashMap;
};

/**
 * Gives access to the GlobalRoutingHashMap
 */
class GlobalRoutingHashMapAccess : public ModuleAccess<GlobalRoutingHashMap>
{
public:
    GlobalRoutingHashMapAccess() : ModuleAccess<GlobalRoutingHashMap>("routingHashMap")
    {}
}
;


#endif

