//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __SIMPLENETCONFIGURATOR_H__
#define __SIMPLENETCONFIGURATOR_H__


#include <omnetpp.h>
#include <BasicModule.h>

#include <UnderlayConfigurator.h>
#include <InitStages.h>

class GlobalRoutingHashMap;


class SimpleNetConfigurator : public UnderlayConfigurator
{
private:
    /**
     * creates an overlay node
     */
    int createRandomNode(bool initialize);

    /**
     * Removes randomly chosen overlay nodes from a randomly chosen access net.
     */
    void killRandomNode();

    /**
     * Migrates randomly chosen overlay nodes from on access net to another.
     */
    void migrateRandomNode();

protected:

    void initializeUnderlay(int stage);
    void finish();
    void setDisplayString();

    GlobalRoutingHashMap* routingHashMap;
    uint32 nextFreeAddress;
    cModuleType* moduleType;

    uint sendQueueLength; //!< send queue length of overlay terminals

    // statistics
    int numCreated;
    int numKilled;
};


#endif
