//
// Copyright (C) 2000 Institut fuer Telematik, Universitaet Karlsruhe
// Copyright (C) 2004 Andras Varga
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file SimpleNodeEntry.h
 * @author Bernhard Heep
 * @date 2006/11/30
 */

#ifndef __SIMPLENODEENTRY_H
#define __SIMPLENODEENTRY_H


#include <omnetpp.h>
#include "SimpleUDPPacket_m.h"

/**
 * representation of a single node in the GlobalRoutingHashMap
 *
 * @author Bernhard Heep
 */
class SimpleNodeEntry : public cPolymorphic
{
public:

    /**
     * Constructor
     *
     * @param node pointer to new terminal
     * @param type access channel of new terminal
     */
    SimpleNodeEntry(cModule* node,
                    cChannelType* type);

    /**
     * Getter for SimpleUDP ingate
     *
     * @return the ingate
     */
    inline cGate* getGate() const
    {
        return ingate;
    };

    /**
     * Setter for maximum coordinate
     *
     * @param size maximum coordinate
     */
    inline static void setFieldSize(uint size)
    {
        fieldSize = size;
    };

    /**
     * Setter for send queue length
     *
     * @param length send queue length
     */
    inline static void setSendQueueLength(uint length)
    {
        sendQueueLength = length;
    };

    typedef std::pair<simtime_t, bool> SimpleDelay; //!< type for return value of calcDelay()
    /**
     * Calculates delay between two nodes
     *
     * @param msg reference to message to get its length for delay calculation,
     * @param dest destination terminal
     * @return delay in s and boolean value that is false if message should be deleted
     */
    SimpleDelay calcDelay(const SimpleUDPPacket& msg, const SimpleNodeEntry& dest);

    /**
     * OMNeT++ info method
     *
     * @return infostring
     */
    std::string info() const;

    /**
     * Stream output
     *
     * @param out output stream
     * @param entry the terminal
     * @return reference to stream out
     */
    friend std::ostream& operator<<(std::ostream& out, const SimpleNodeEntry& entry);

protected:

    /**
     * Calculates eulklidean distance between two terminals
     *
     * @param entry destination entry
     * @return the euklidean distance
     */
    float operator-(const SimpleNodeEntry& entry) const;

    cGate* ingate; //!< ingate of the SimpleUDP module of this terminal

    float x; //!< x-coordinate
    float y; //!< y-coordinate
    simtime_t txFinished; //!< send queue finished
    //simtime_t rxFinished;
    simtime_t txMaxQueueTime; //!< maximum time for packets to be queued
    //simtime_t rxMaxQueueTime;
    simtime_t accessDelay; //!< first hop delay
    float bandwidth; //!< bandwidth in access net
    float errorRate; //!< packet loss rate

    static uint fieldSize; //!< maximum coordinates
    static uint sendQueueLength; //!< maximum send queue length of overlay terminals in bytes
};


#endif // __SIMPLENODEENTRY_H
