
#include "RealworldApp.h"


Define_Module(RealworldApp);

char* RealworldApp::encapsulate(cMessage *msg, unsigned int* length)
{
    unsigned int payloadLen;
    // parse payload
    char* payload = parser->encapsulatePayload(msg, &payloadLen);
    if (!payload )
        return NULL;

    if(payloadLen > 0xffff) {
	opp_error("RealworldApp: Encapsulating packet failed: packet too long");
    }
    *length = payloadLen;

    return payload;
}

cMessage* RealworldApp::decapsulate(char* buf, uint32_t length)
{
    cMessage* payload = 0; 
    // "Decode" packet: 16bit payload length|payload
    payload = parser->decapsulatePayload( buf, length );
    if (!payload) {
        ev << "RealworldApp: Parsing of Payload failed, dropping packet.\n";
    }

    delete buf;
    return payload;
}

