#ifndef _REALWORLDAPP_H__
#define _REALWORLDAPP_H__

#include "tunoutscheduler.h"
#include "RealworldConnector.h"

/**
 * Applicaton that communicates with a realword application via a socket
 */
class RealworldApp : public RealworldConnector
{
protected:

    /**
     * Converts an IP datagram to a data block for sending it to the tun device
     *
     * \param msg A pointer to the message to be converted
     * \param length A pointer to an int that will hold the length of the converted data
     * \return A pointer to the converted data
     */
    virtual char* encapsulate(cMessage *msg, unsigned int* length);

    /**
     * Parses data received from the tun device and converts it into a cMessage
     *
     * \param buf A pointer to the data to be parsed
     * \param length The length of the buffer in bytes
     * \return The parsed message
     */
    virtual cMessage *decapsulate(char* buf, uint32_t length);

    /**
     * The Connector connects to an application, so this method to returns "true"
     * \return true
     */
    virtual bool isApp() {return true;}

public:
    Module_Class_Members(RealworldApp, RealworldConnector, 0);

};

#endif


