#include <string.h>
#include <omnetpp.h>

#include "RealworldConnector.h"


void RealworldConnector::initialize(int stage)
{
    if (stage==3) {
        // update display string when addresses have been autoconfigured etc.
        updateDisplayString();
        return;
    }

    // all initialization is done in the first stage
    if (stage!=0)
        return;

    packetNotification = new cMessage("packetNotification");
    mtu = par("mtu");

    scheduler = check_and_cast<RealtimeScheduler *>(simulation.scheduler());
    scheduler->setInterfaceModule(this, packetNotification, &packetBuffer, mtu, isApp());

//    parser = check_and_cast<PacketParser*>(parentModule()->submodule("packetParser"));
    if (!isApp() ) {
	parser = check_and_cast<PacketParser*>(parentModule()->submodule("packetParser"));
    } else {
	parser = check_and_cast<PacketParser*>(parentModule()->submodule("applicationParser"));
    }

    numSent = numRcvdOK = numRcvError = numSendError = 0;
    WATCH(numSent);
    WATCH(numRcvdOK);
    WATCH(numRcvError);
    WATCH(numSendError);

    if (!isApp() ) {
	gateIndexNetwOut = gate("netwOut")->id();
    } else {
	gateIndexNetwOut = gate("to_lowerTier")->id();
    }

}


void RealworldConnector::handleMessage(cMessage *msg)
{
    // Packet from the real world...
    if (msg==packetNotification) {
        EV << "RealworldConnector: Message from outside. Queue length = " << packetBuffer.size() << ".\n";
        while( packetBuffer.size() > 0 ) {
            // get packet from buffer and parse it

            RealtimeScheduler::PacketBufferEntry packet = *(packetBuffer.begin());
            packetBuffer.pop_front();
	    char* buf = packet.data;
	    uint32_t len = packet.length;
            cMessage *parsedPacket = decapsulate(buf, len);
            if (parsedPacket) {
                numRcvdOK++;
                send(parsedPacket, gateIndexNetwOut);
            } else {
                numRcvError++;
            }

        }
    } else // arrived on gate "netwIn"
    {
        // Packet from inside, send to real word
        EV << "Received " << msg << " for transmission\n";

        transmitToNetwork(msg);
    }

    if (ev.isGUI())
        updateDisplayString();

}

void RealworldConnector::transmitToNetwork(cMessage *msg)
{
    unsigned int length;
    char* buf = encapsulate(msg, &length);
    if( buf ) {
        numSent++;
        scheduler->sendBytes( buf, length, isApp() );
    } else {
        numSendError++;
    }
    delete buf;
}

void RealworldConnector::updateDisplayString()
{
    char buf[80];
    if (ev.disabled()) {
        // speed up things
        displayString().setTagArg("t",0,"");
    }
    sprintf(buf, "rcv:%ld snt:%ld", numRcvdOK, numSent);

    if (numRcvError>0)
        sprintf(buf+strlen(buf), "\nerrin:%ld errout:%ld", numRcvError, numSendError);

    displayString().setTagArg("t",0,buf);
}

