#ifndef _REALWORLDCONNECTOR_H_
#define _REALWORLDCONNECTOR_H_

#include <omnetpp.h>
#include "INETDefs.h"
#include "realtimescheduler.h"
#include "PacketParser.h"

/**
 * helper funcition needed for computing checksums
 *
 * \param buf The buffer containing the data to be checksummed
 * \param nbytes The length of the buffer in bytes
 * \return the Checksum
 */
inline u_short cksum(uint16_t *buf, int nbytes)
{
    register unsigned long  sum;
    u_short                 oddbyte;

    sum = 0;
    while (nbytes > 1) {
        sum += *buf++;
        nbytes -= 2;
    }

    if (nbytes == 1) {
        oddbyte = 0;
        *((u_char *) &oddbyte) = *(u_char *) buf;
        sum += oddbyte;
    }

    sum = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);

    return ~sum;
}

/**
 * RealworldConnector is a pseudo interface that allows communcation with the real world
 * through the TunOutScheduler
 */
class INET_API RealworldConnector : public cSimpleModule
{
protected:

    int gateIndexNetwOut;
    unsigned int mtu;
#define BUFFERZITE mtu + 4 // 4 bytes for packet information

    // statistics
    long numSent;
    long numSendError;
    long numRcvdOK;
    long numRcvError;

    cMessage* packetNotification; // used by TunOutScheduler to nitify about new packets
    RealtimeScheduler::PacketBuffer packetBuffer; // recieved packets are stored here
    RealtimeScheduler* scheduler;
    PacketParser* parser;

    /** Send a message to the (realworld) network
     *  
     * \param msg A pointer to the message to be send
     */
    virtual void transmitToNetwork(cMessage *msg);
    virtual void updateDisplayString();

    /**
     * Converts an IP datagram to a data block for sending it to the (realworld) network
     *
     * \param msg A pointer to the message to be converted
     * \param length A pointer to an int that will hold the length of the converted data
     * \return A pointer to the converted data
     */
    virtual char* encapsulate(cMessage *msg, unsigned int* length) = 0;

    /**
     * Parses data received from the (realworld) network and converts it into a cMessage
     *
     * \param buf A pointer to the data to be parsed
     * \param length The lenght of the buffer in bytes
     * \return The parsed message
     */
    virtual cMessage *decapsulate(char* buf, uint32_t length) = 0;

    /**
     * If the Connector connects to an application, this method has to be overwritten to return "true"
     * \return false
     */
    virtual bool isApp() {return false;}

public:
    Module_Class_Members(RealworldConnector, cSimpleModule, 0);

    virtual int numInitStages() const
    {
        return 4;
    }

    /** Initialization of the module.
     * Registers the device at the scheduler and searches for the appropriate payload-parser
     * Will be called automatically at startup
     */
    virtual void initialize(int stage);

    /**
     * The "main loop". Every message that is received or send is handled by this method
     */
    virtual void handleMessage(cMessage *msg);
};

#endif


