#include "RealworldDevice.h"


void RealworldDevice::initialize(int stage)
{

    RealworldConnector::initialize(stage);

    // register our interface entry in RoutingTable
    if (stage == 0) {
        interfaceEntry = registerInterface();
    }

}

InterfaceEntry *RealworldDevice::registerInterface()
{
    InterfaceEntry *e = new InterfaceEntry();

    // interface name: our module name without special characters ([])
    char *interfaceName = new char[strlen(fullName())+1];
    char *d=interfaceName;
    for (const char *s=fullName(); *s; s++)
        if (isalnum(*s))
            *d++ = *s;
    *d = '\0';

    e->setName(interfaceName);
    delete [] interfaceName;

    // port: index of gate where our "netwIn" is connected (in IP)
    int outputPort = /*parentModule()->*/gate("netwIn")->fromGate()->index();
    e->setNodeOutputGateId(outputPort);

    // generate a link-layer address to be used as interface token for IPv6
    InterfaceToken token(0, simulation.getUniqueNumber(), 64);
    e->setInterfaceToken(token);

    // MTU: typical values are 576 (Internet de facto), 1500 (Ethernet-friendly),
    // 4000 (on some point-to-point links), 4470 (Cisco routers default, FDDI compatible)
    e->setMtu(mtu);

    // capabilities
    e->setMulticast(true);
    e->setPointToPoint(true);

    // add
    InterfaceTable *ift = InterfaceTableAccess().get();
//    ift->addInterface(e, NULL);
    ift->addInterface(e, this);

    return e;
}


