#ifndef _REALWORLDDEVICE_H_
#define _REALWORLDDEVICE_H_

#include "RealworldConnector.h"

#include "InterfaceTable.h"
#include "InterfaceTableAccess.h"

/**
 * RealworldDevice is a pseudo interface that allows communcation with the real world
 * through the TunOutScheduler
 *
 * WARNING: This does ONLY work with the combination IPv4|UDP|OverlayMessage
 */
class RealworldDevice : public RealworldConnector
{
protected:

    InterfaceEntry *interfaceEntry;  // points into InterfaceTable

    /** Register the interface in the interface table of the parent
     *
     * \return A pointer to the Interface entry
     */
    InterfaceEntry *registerInterface();

public:
    Module_Class_Members(RealworldDevice, RealworldConnector, 0);

    virtual int numInitStages() const
    {
        return 4;
    }

    /** Initialization of the module.
     * Registers the device at the scheduler and searches for the appropriate payload-parser
     * Will be called automatically at startup
     */
    virtual void initialize(int stage);

};

#endif


