//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

/**
 * @file SingleHostConfigurator.cc
 * @author Stephan Krause
 * @author Bernhard Heep (migrateRandomNode)
 */

#include <omnetpp.h>

#include "InterfaceTable.h"
#include "InterfaceEntry.h"
#include "IPv4InterfaceData.h"
#include "IPAddressResolver.h"

#include <RoutingTable.h>
#include <NodeHandle.h>
#include <BootstrapOracleAccess.h>

#include "SingleHostConfigurator.h"


Define_Module(SingleHostConfigurator);

void SingleHostConfigurator::initializeUnderlay(int stage)
{
    if(stage != MAX_STAGE_UNDERLAY)
        return;

    overlayTerminalCount = 1;
    // flag indicating simulation initialization phase (true)
    // vs. normal mode (false)
    init = true;

    // Set IP, Routes, etc
    cModule* node = parentModule()->submodule("singleHost", 0);
    IPvXAddress addr = IPAddress(par("nodeIP").stringValue());
    IPvXAddress gw = IPAddress(par("gatewayIP").stringValue());
    InterfaceEntry* ifEntry = IPAddressResolver().interfaceTableOf(node)->
	    interfaceByName("tunDev");
    RoutingTable* rTable = (RoutingTable*) node->submodule("routingTable", 0);
    ifEntry->ipv4()->setInetAddress(addr.get4());
    ifEntry->ipv4()->setNetmask(IPAddress::ALLONES_ADDRESS);

    RoutingEntry* te = new RoutingEntry();
    te->host = IPAddress::UNSPECIFIED_ADDRESS;
    te->netmask = IPAddress::UNSPECIFIED_ADDRESS;
    te->gateway = gw.get4();
    te->interfaceName = "tunDev";
    te->interfacePtr = ifEntry;
    te->type = RoutingEntry::REMOTE;
    te->source = RoutingEntry::MANUAL;
    rTable->addRoutingEntry(te);

    if ( strlen(par("bootstrapIP")) > 0 ) {
	NodeHandle bootstrapNode(OverlayKey::ONE, 
		IPAddress(par("bootstrapIP").stringValue()), 
		par("bootstrapPort"),
		0);
	BootstrapOracleAccess a;
	a.get()->registerPeer(bootstrapNode);
    }

    // update display
    setDisplayString();

}

void SingleHostConfigurator::setDisplayString()
{
    //
    // Updates the statistics display string.
    //

    char buf[80];
    sprintf(buf, "%i overlay clients", overlayTerminalCount);
    displayString().setTagArg("t", 0, buf);
}

void SingleHostConfigurator::finish()
{
    struct timeval now, diff;
    gettimeofday(&now, NULL);
    timersub(&now, &initFinishedTime, &diff);
    printf("Simulation time: %li.%06li\n", diff.tv_sec, diff.tv_usec);
}
