#ifndef _TUNOUTDEVICE_H__
#define _TUNOUTDEVICE_H__

#include "tunoutscheduler.h"
#include "RealworldDevice.h"

/**
 * TunOutDevice is a pseudo interface that allows communcation with the real world
 * through the TunOutScheduler
 *
 * WARNING: This does ONLY work with the combination IPv4|UDP|OverlayMessage
 */
class TunOutDevice : public RealworldDevice
{
protected:

    /**
     * Converts an IP datagram to a data block for sending it to the tun device
     *
     * \param msg A pointer to the message to be converted
     * \param length A pointer to an int that will hold the length of the converted data
     * \return A pointer to the converted data
     */
    virtual char* encapsulate(cMessage *msg, unsigned int* length);

    /**
     * Parses data received from the tun device and converts it into a cMessage
     *
     * \param buf A pointer to the data to be parsed
     * \param length The lenght of the buffer in bytes
     * \return The parsed message
     */
    virtual cMessage *decapsulate(char* buf, uint32_t length);

public:
    Module_Class_Members(TunOutDevice, RealworldDevice, 0);

};

#endif


