#include "tunoutscheduler.h"

Register_Class(TunOutScheduler);

TunOutScheduler::~TunOutScheduler()
{
    delete dev;
}


int TunOutScheduler::initializeNetwork()
{
    // Initialize TUN device for network communication
    // see /usr/src/linux/Documentation/network/tuntap.txt
    struct ifreq ifr;
    int err;
    dev = new char[IFNAMSIZ];

    // get app port (0 if external app is not used)
    int appPort = ev.config()->getAsInt("ExternalApp", "app-port");

    if (netw_fd > 0) {
        opp_error("Already bound to TUN device!");
	return -1;
    }
    if( (netw_fd = open("/dev/net/tun", O_RDWR)) < 0 ) {
        opp_error("Error opening tun device");
	return -1;
    } else {
        ev << "TunOutScheduler: Successfully opened TUN device.\n";
    }

    memset(&ifr, 0, sizeof(ifr));

    /* Flags: IFF_TUN   - TUN device (no Ethernet headers)
     *        IFF_TAP   - TAP device  
     * 
     *        IFF_NO_PI - Do not provide packet information  
     */
    ifr.ifr_flags = IFF_TUN | IFF_NO_PI;
    strncpy(ifr.ifr_name, "tun%d", IFNAMSIZ);

    if((err = ioctl(netw_fd, TUNSETIFF, (void *) &ifr)) < 0 ) {
        close(netw_fd);
        opp_error("Error ioctl tun device");
	return -1;
    }
    strncpy(dev, ifr.ifr_name, IFNAMSIZ);
    ev << "TunOutScheduler: Bound to device " << dev << "\n";
    if (appPort == 0) opp_warning("Bring up TUN device with ifconfig before proceeding");

    // Initialize TCP socket for App communication if desired
    if ( appPort > 0 ) {

	struct sockaddr_in server;
	int sock;

	// Waiting for a TCP connection
	// WARNING: Will only accept exactly ONE app connecting to the socket
	// WARNING: Blocks until connection to app is established
	sock = socket( AF_INET, SOCK_STREAM, 0 );
	if (sock < 0) {
	    opp_error("Error creating socket");
	    return -1;
	}
	memset( &server, 0, sizeof (server));
	server.sin_family = AF_INET;
	server.sin_addr.s_addr = htonl( INADDR_ANY );
	server.sin_port = htons( appPort );

	if(bind( sock, (struct sockaddr*)&server, sizeof( server)) < 0) {
	    opp_error("Error binding to app socket");
	    return -1;
	}
	if( listen( sock, 5 ) == -1 ) {
	    opp_error("Error listening on app socket");
	    return -1;
	}
	opp_warning("Immediately after acknowledging this message, bring up TUN"
		"device with ifconfig and connect the external app with tcp to "
		"port %i ", appPort);
	app_fd = accept( sock, 0, 0 );
	if (app_fd < 0) {
	    opp_error("Error connecting to remote app");
	    return -1;
	}
    }
    return 0;
}


